namespace SupplementaryAreaPlugin;

/// <summary>
/// Shared constants for the Supplementary Areas plugin logic.
/// Extracted from the partial <c>SupplementaryAreasPlugin</c> class so they can be reused
/// across actions (e.g. people search) and any future components without relying on
/// the partial class pattern. All fields are public constants for easy consumption.
/// </summary>
public static class SupplementaryAreasConstants
{
    public const string ModelKeyPrefix = "suppArea:model:";

    public const int MaxAreasLimit = 20;
    public const int MaxPayloadSafetyLimit = 50;
    public const int PeopleSearchLimit = 10;

    public const int MaxJsonPayloadSize = 1024 * 1024;
    public const int MaxStringLength = 10000;
    public const int MaxSearchTermLength = 100;
    public const int MaxCommentsLength = 2000;
    public const int MaxLabelLength = 200;

    public const string PeopleSearchAction = "peopleSearch";
    public const string UpdateRecordAction = "updateRecord";
    
    // Universal action names
    public const string UniversalActionGetCurrentUser = "GetCurrentUser";
    public const string UniversalActionGetContentTypeFields = "GetContentTypeFields";
    public const string UniversalActionUpdateRecordFields = "UpdateRecordFields";
    public const string UniversalActionLogAuditEntry = "LogAuditEntry";
    public const string UniversalActionSendNotification = "SendNotification";
    public const string UniversalActionSendKeyDetailsChangedNotification = "SendKeyDetailsChangedNotification";
    public const string UniversalActionGetOrgLevel1 = "GetOrgLevel1";
    public const string UniversalActionSearchUsers = "SearchUsers";
    
    // Email template paths (relative to plugin folder)
    public const string EmailTemplateLeaderAssigned = "email/LeaderAssigned.html";
    public const string EmailTemplateContributorAssigned = "email/ContributorAssigned.html";
    public const string EmailTemplateEndorsementCompleted = "email/EndorsementCompleted.html";
    
    public const string ErrorNotInitialised = "not_initialised";
    public const string ErrorMissingRecordId = "missing_recordId";
    public const string ErrorInvalidJson = "invalid_json";
    public const string ErrorUnknownAction = "unknown_action";
    public const string ErrorInvalidModel = "invalid_model";
    public const string ErrorMissingKeyValues = "missing_keyValues";
    public const string ErrorNoUpdates = "no_updates";
    public const string ErrorParamBuildFailed = "param_build_failed";
    public const string ErrorActionFailed = "action_failed";
    public const string ErrorUpdateFailed = "update_failed";

    public const string QueryRecordId = "recordId";
    public const string QueryAction = "action";
    public const string QuerySearchTerm = "q";
    public const string JsonDueDate = "dueDate";
    public const string JsonAreas = "areas";
    public const string JsonKeyValues = "keyValues";
    public const string JsonComments = "comments";
    public const string JsonError = "error";

    public const string LegacyNameLabel = "nameLabel";
    public const string LegacyNameId = "nameId";

    public const string FieldNameLeadAuthor = "ABCLeadAuthor";
}
